<?php

namespace IZON\DB\EntityManager;

use Doctrine\Common\EventManager;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager as ORMEntityManager;
use Doctrine\ORM\ORMException;
use InvalidArgumentException;
use IZON\DB\ConnectionInterface;
use IZON\DB\Connections\Connection;
use IZON\DB\EntityManagerInterface;

/**
 * {inheritDoc}
 *
 * @author Lukáš Linhart
 */
class EntityManager extends ORMEntityManager implements EntityManagerInterface {

    /**
     * create method overridden from doctrine, because of not static creating of instance
     *
     * @param array|ConnectionInterface $connection   An array with the connection parameters or an existing Connection instance.
     * @param Configuration    $config       The Configuration instance to use.
     * @param EventManager     $eventManager The EventManager instance to use.
     *
     * @return EntityManager The created EntityManager.
     *
     * @throws InvalidArgumentException
     * @throws ORMException
     */
    public static function create($connection, Configuration $config, EventManager $eventManager = null) {
        if (!$config->getMetadataDriverImpl()) {
            throw ORMException::missingMappingDriverImpl();
        }

        $connection = static::createConnection($connection, $config, $eventManager);

        return new static($connection, $config, $connection->getEventManager());
    }

    public function getRepository($entityName) {
        return parent::getRepository($entityName); // TODO: Change the autogenerated stub
    }

}
