<?php

namespace IZON\DB;

use IZON\Logs\Logger;
use ReflectionClass;
use Laminas\Code\Generator\ClassGenerator;
use Laminas\Code\Generator\MethodGenerator;
use Laminas\Code\Generator\ParameterGenerator;
use IZON\DB\Connections\Configuration as DBConnectionConfiguration;
use function IZON\String\startsWith;

/**
 * creates proxy to manage transactions
 * probaby should be move somewhere else
 */
class TransactionManagementFactory {

    /**
     * @var ConnectionInterface
     */
    protected $connection;

    /**
     * na jaky objekt se maji preposilat pozadavky
     * @var object
     */
    protected $proxyObject;

    /**
     * @var string
     */
    protected $proxyObjectInterfaceClass;

    /**
     *
     * @var Logger
     */
    private $log;


    public function __construct(ConnectionInterface $connection, $proxyObject, $proxyObjectInterfaceClass = null) {
        $this->connection = $connection;
        $this->proxyObject = $proxyObject;

        $this->proxyObjectInterfaceClass = $proxyObjectInterfaceClass;
        if( $this->proxyObjectInterfaceClass === null ) {
            $this->proxyObjectInterfaceClass = get_class($this->proxyObject);
        }

        $this->log = Logger::getLogger(self::class);
    }


    public function create() {
        $objectReflectionClass = new ReflectionClass($this->proxyObjectInterfaceClass); // class Foo of namespace A

        $proxyClassName = $objectReflectionClass->getName() ."TxProxy";

        // class is not created yet
        if(!class_exists($proxyClassName)) {
            $proxyClassFileName = $this->getProxyClassFileName($proxyClassName);
            $daoFileLastModified = filemtime($objectReflectionClass->getFileName());

            if( $proxyClassFileName != null // je definovan adresar kam cachovat daa
                && file_exists($proxyClassFileName) // uz existuje vygenerovane dao
                && $daoFileLastModified <= filemtime($proxyClassFileName) ) { // cache je novejsi nez soubor ve kterem byl vygenerovan
                // vem dao z cache
                require_once $proxyClassFileName;
            } else {
                $gemenratd = $this->generateProxyClassSourceCode($objectReflectionClass, $proxyClassName);
                eval($gemenratd);

                if($proxyClassFileName !== null) { // there is proxy file name defined
                    // write cahce
                    $proxyClassDirName = dirname($proxyClassFileName);
                    if(!file_exists($proxyClassDirName)) { // neni soubor do ktereho se ma zapsat
                        if(!@mkdir($proxyClassDirName, 0777, true)) { // nevyhazovat warning pokud jiz adresar existuje
                            $this->log->warning(
                                "Unable to create dir $proxyClassDirName for transaction proxy "
                                .$this->proxyObjectInterfaceClass
                                ." cache"
                            );
                        }
                    }
                    if(!file_put_contents($proxyClassFileName, "<?php\r\n".$gemenratd, LOCK_EX)) {
                        $this->log->warning(
                            "Unable to write transaction proxy for ".$this->proxyObjectInterfaceClass." to "
                        );
                    }
                    if(file_exists($proxyClassFileName)) {
                        chmod($proxyClassFileName, 0777);
                    }
                }
            }
        }

        $object = new $proxyClassName($this->connection, $this->proxyObject);
        return $object;
    }

    protected function generateProxyClassSourceCode(ReflectionClass $objectReflectionClass, string $proxyClassName): string {
        $parentClass = null;
        $implInterfaces = [];
        if( $objectReflectionClass->isInterface() ) {
            $implInterfaces[] = "\\". $objectReflectionClass->getName();
        } else {
            $parentClass = "\\". $objectReflectionClass->getName();
        }

        $class = new ClassGenerator(
            $proxyClassName,
            $objectReflectionClass->getNamespaceName(),
            null,
            $parentClass,
            $implInterfaces
        );

        // vytvori konstruktor pro predani parametru
        $method = new MethodGenerator(
            "__construct",
            [
                new ParameterGenerator("connection", "\IZON\DB\ConnectionInterface"),
                "proxyObject"
            ]
        );
        $method->setBody('$this->connection = $connection; $this->proxyObject = $proxyObject;');
        $class->addMethodFromGenerator($method);

        // prochaci metody rozhrani daa
        foreach($objectReflectionClass->getMethods() as $method) {
            if($method->getName() == '__construct') { // skip constructor
                continue;
            }

            if(!$method->isPublic()) { // export only public methods
                continue;
            }

            $declaringClass = $method->getDeclaringClass();
            // pridat metodu
            $parameters = [];
            $paransNames = [];
            foreach($method->getParameters() as $parameter) {
                /* @var $parameter \ReflectionParameter */
                $parameterTypeName = null;

                // najit typ parametru
                if( $parameter->hasType() ) {
                    $parameterTypeName = $parameter->getType()->getName();
                    // allows null ? and not provided in param name
                    if( $parameter->allowsNull() && !startsWith($parameterTypeName, '?') ) {
                        $parameterTypeName = '?'. $parameterTypeName;
                    }
                }

                $paramGenerator = new ParameterGenerator($parameter->getName(), $parameterTypeName);
                if($parameter->isDefaultValueAvailable()) {
                    $paramGenerator->setDefaultValue($parameter->getDefaultValue());
                }

                $parameters[] = $paramGenerator;
                $paransNames[] = '$'.$parameter->getName();
            }

            // vytvori dummy metody pro volani
            $generatedMethod = new MethodGenerator($method->getName(), $parameters);

            if( $method->hasReturnType() ) {
                $returnType = $method->getReturnType();
                $returnTypeName = $returnType->getName();
                // allows null ?
                if( $returnType->allowsNull() ) {
                    $returnTypeName = '?'. $returnTypeName;
                }
                $generatedMethod->setReturnType($returnTypeName);
            }

            $functionRet = ' return $ret; ';
            if( $returnType !== null && $returnType->getName() === 'void' ) {
                $functionRet = '';
            }
            $generatedMethod->setBody(
                '$this->connection->beginTransaction(); '
                .' try { '
                    .' $ret = $this->proxyObject->'.$method->getName().'('.implode(", ", $paransNames).');'
                    .' $this->connection->commit(); '
                    . $functionRet
                .' } catch (\Throwable $e) {'
                    .' $this->connection->rollBack(); '
                    .' throw $e; '
                .' }'
            );

            $class->addMethodFromGenerator($generatedMethod);
        }

        $gemenratd = $class->generate();

        $this->log->info("Generated class: ".print_r($gemenratd, true));

        return $gemenratd;
    }

    protected function getProxyClassFileName(string $proxyClassName) {
        $dbConnectionConfig = $this->connection->getConfiguration();
        if( $dbConnectionConfig instanceof  DBConnectionConfiguration
            && $dbConnectionConfig->getProxyDir() !== null ) {
            $proxyClassFileName = $dbConnectionConfig->getProxyDir() ."/Transactions/". str_replace('\\', '', $proxyClassName) .".php";
            return $proxyClassFileName;
        }
        return null;
    }
}