<?php

namespace IZON\DB\QueryFactory;

use Doctrine\ORM\AbstractQuery;
use IZON\DB\EntityManagerInterface;
use IZON\DB\QueryParams\QueryParamsInterface;
use IZON\DB\Paginator\PaginatorConfigInterface;

/**
 * QueryFactoryInterface
 * Provides factory interface for query creation   
 * @author Aleš Kopecký <kopecky@izon.cz>
 * @author IZON s.r.o. <info@izon.cz>
 */
interface QueryFactoryInterface {

    const DEFAULT_QUERY_NAME = PaginatorConfigInterface::DEFAULT_QUERY_NAME;
    
    /**
     * @return string returns query name query factory creates
     */
    public function getQueryName(): string;
    
    /**
     * @param string $queryName
     * @param EntityManagerInterface $em
     * @param QueryParamsInterface $queryParams
     * @return AbstractQuery
     */
    public function getQuery(EntityManagerInterface $em, QueryParamsInterface $queryParams): AbstractQuery;

    /**
     * @return string[] regexes defining parameter names
     */
    public function getParameterDefinitionNames(): array;

    /**
     * 
     * @return string[] regexes defining control parameters to use for construction of query, not passed to db
     */
    public function getControlParameterDefinitionNames(): array;

    /**
     * 
     * @return string[] regexes (NOTE Dave: not completly shure about regex) defining orders that can be used
     */
    public function getOrderDefinitions(): array;
}
