<?php

namespace IZON\DB\Types;

use Doctrine\DBAL\Platforms\AbstractPlatform;

/**
 * Date time type for mapping to db.
 */
class DateTimeType extends DateType {
    
    const IZON_DATETIME = 'izon_datetime';
    
    /**
     * {@inheritdoc}
     */
    public function getName(): string {
        return self::IZON_DATETIME;
    }

    /**
     * Gets date format string.
     * @return string
     */
    protected function getFormat(): string{
        return 'Y-m-d H:i:s';
    }

    public function getSQLDeclaration(array $fieldDeclaration, AbstractPlatform $platform): string {
        return $platform->getDateTimeTypeDeclarationSQL($fieldDeclaration);
    }
    
}