<?php


namespace IZON\DB\Extensions\Functions;


use Doctrine\ORM\Query\AST\Functions\FunctionNode;
use Doctrine\ORM\Query\Lexer;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;

class IsNull extends FunctionNode {

    public $argument;

    public function getSql(SqlWalker $sqlWalker) {
        return $sqlWalker->walkArithmeticPrimary($this->argument).' IS NULL';
    }

    public function parse(Parser $parser) {
        $parser->match(Lexer::T_IDENTIFIER);
        $parser->match(Lexer::T_OPEN_PARENTHESIS);
        $this->argument = $parser->ArithmeticPrimary();
        $parser->match(Lexer::T_CLOSE_PARENTHESIS);
    }
}
