<?php

namespace IZON\DB\Utils;

use PDOStatement;

/**
 * Slouzi ke cachvani statmenentu pro jednotlive db objekty
 */
class SqlStatementCache
{
    /**
     * cache prepared statementu pro zakladni metody
     * klicem
     * @var array
     */
    protected $sqlStatementsCache = [];


    public function hasStatement($statementName)
    {
        return isset($this->sqlStatementsCache[$statementName]);
    }

    /**
     *
     * @param string $statementName
     * @return PDOStatement
     */
    public function getStatement($statementName)
    {
        return $this->sqlStatementsCache[$statementName];
    }

    public function setStatement($statementName, $statement)
    {
        $this->sqlStatementsCache[$statementName] = $statement;
    }
}
