<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use Exception;
use IZON\DB\Utils\ClassDescription;
use PDO;

/**
 * description of text field
 */
class TextDescription extends AbstractPropertyDescription
{
    /**
     * @var integer max length of string
     */
    protected $maxLength = PHP_INT_MAX;


    public function __construct(ClassDescription $classDescription, $propertyName, $columnName, $columnReturnName, $notNull, array $parameters)
    {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "text";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_CHAR_VARYING;
    }

    public function parse($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        if (mb_strlen($value) > $this->maxLength) {
            throw new Exception("" . $this->getPropertyName() . " nesmi byt delsi nez " . $this->maxLength);
        }

        $date = $value;
        return $date;
    }

    public function serialize($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        if (mb_strlen($value) > $this->maxLength) {
            throw new Exception("" . $this->getPropertyName() . " nesmi byt delsi nez " . $this->maxLength);
        }

        return $value;
    }

    public function getPdoDataType($value)
    {
        if ($value === null) {
            return PDO::PARAM_NULL;
        }
        return $this->pdoDataType;
    }

    public function getMaxLength()
    {
        return $this->maxLength;
    }

    public function setMaxLength($maxLength)
    {
        $this->maxLength = $maxLength;
    }
}
