<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use Exception;
use IZON\DB\Utils\ClassDescription;
use PDO;

/**
 * Popis data
 */
class FloatDescription extends AbstractPropertyDescription
{
    public function __construct(
        ClassDescription $classDescription,
        $propertyName,
        $columnName,
        $columnReturnName,
        $notNull,
        array $parameters
    ) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "float";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_FLOAT;
    }

    public function parse($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        $number = doubleval($value);
        return $number;
    }

    public function serialize($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        // TODO: resit floaty nejak lepe nez menit carku za tecku
        return "" . str_replace(",", ".", $value);
    }

    public function getPdoDataType($value)
    {
        if ($value === null) {
            return PDO::PARAM_NULL;
        }
        return $this->pdoDataType;
    }
}
