<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use Exception;
use IZON\DB\Utils\ClassDescription;
use IZON\Utils\Date;
use PDO;

/**
 * Popis data
 */
class DateTimeDescription extends AbstractPropertyDescription
{
    protected $format = "Y-m-d H:i:s";

    public function __construct(
        ClassDescription $classDescription,
        $propertyName,
        $columnName,
        $columnReturnName,
        $notNull,
        array $parameters
    ) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "date";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_TIMESTAMP;
    }

    public function parse($value, $object)
    {
        if ($value == null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        $date = Date::createFromFormat($this->format, $value);
        return $date;
    }

    public function serialize($value, $object)
    {
        if ($value == null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }
        if (!($value instanceof Date)) {
            throw new Exception("Hodnota musi byt null nebo IZON\Utils\Date");
        }

        $serializedString = $value->format($this->format);
        return $serializedString;
    }

    public function getPdoDataType($value)
    {
        if ($value == null) {
            return PDO::PARAM_NULL;
        }
        return $this->pdoDataType;
    }
}
