<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use Exception;
use IZON\DB\Utils\ClassDescription;
use PDO;

/**
 * Popis dat
 */
class BooleanDescription extends AbstractPropertyDescription
{
    public function __construct(
        ClassDescription $classDescription,
        $propertyName,
        $columnName,
        $columnReturnName,
        $notNull,
        array $parameters
    ) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "boolean";
        $this->pdoDataType = PDO::PARAM_INT;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_BOOLEAN;
    }

    public function parse($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        $date = boolval($value);
        return $date;
    }

    public function serialize($value, $object)
    {
        if ($value === null) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return null;
        }

        return boolval($value);
    }

    public function getPdoDataType($value)
    {
        if ($value === null) {
            return PDO::PARAM_NULL;
        }
        return $this->pdoDataType;
    }
}
