<?php

namespace IZON\DB\Paginator;

/**
 * strankovac vysledku, ktery obsahuje pozadovanou stranku (jeji prvky)
 * pocet stranek, kolikata stranka to je atd.
 * @template T
 */
class PageContent
{
    /**
     * @var int kompletni mnozstli vysledku bez strankovani
     */
    protected int $totalCount;

    /**
     * @var int zadana velikost stranky, pro kterou se melo strankovat
     */
    protected int $maxPageSize;

    /**
     * prvky prave aktivni stranky
     * @var T[]
     */
    protected array $page;

    /**
     * indexy jednotlivych stranek
     * @var int[]
     */
    protected array $pageIndices;

    public function __construct($totalCount, $maxPageSize, $page)
    {
        $this->totalCount = $totalCount;
        $this->maxPageSize = $maxPageSize;
        $this->page = $page;

        $this->pageIndices = [];

        if ($this->totalCount != 0 && $this->maxPageSize != 0) {
            for ($i = 0; $i <= $totalCount; $i = $i + $maxPageSize) {
                $this->pageIndices[] = $i;
            }
        } else {
            $this->pageIndices[] = 0;
        }
    }

    /**
     * @return T[]
     */
    public function getPage(): array
    {
        return $this->page;
    }

    /**
     * @return int
     */
    public function getMaxPageSize(): int
    {
        return $this->maxPageSize;
    }

    /**
     * @return int
     */
    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    /**
     * @return int[]
     */
    public function getPageIndices(): array
    {
        return $this->pageIndices;
    }
}
