<?php

namespace IZON\DB\Collections;

use IZON\Lang\IndexNotNummericException;
use IZON\Lang\IndexOutOfBoundsException;
use IZON\Lang\NotImplementedException;
use IZON\Utils\ArrayList;
use IZON\Utils\Collection;

/**
 * pouziva pro ukladani dat do db
 * @deprecated use ArrayCollection from doctrine instead
 */
class PersistentArrayList extends ArrayList
{
    /**
     *
     * @param Collection|mixed[]|null $elements elementy seznamu nebo trida, ktara se ma v seznamu ukladat
     * @param string|null $class trida, ktara se ma v seznamu ukladat
     */
    public function __construct($elements = [], $class = null)
    {
        parent::__construct($elements, $class);
    }

    public function add($element, $index = false)
    {
        if ($index === false) {
            $this->elements[] = $element;
            return true;
        }
        if (!is_int($index)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($index)) {
            throw new IndexOutOfBoundsException();
        }

        // posune prvky
        for ($i = count($this->elements) - 1; $i > $index; $i--) {
            $this->elements[$i + 1] = $this->elements[$i];
        }
        $this->elements[$index] = $element;
        return true;
    }

    protected function outOfIndex($index)
    {
        return $index < 0
            || $index >= count($this->elements);
    }

    public function addAll($c)
    {
        throw new NotImplementedException();
    }

    public function clear()
    {
        $this->elements = [];
    }

    public function contains($o)
    {
        return in_array($o, $this->elements, $this->class);
    }

    public function containsAll($c)
    {
        throw new NotImplementedException();
    }

    public function get($index)
    {
        if (!is_int($index)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($index)) {
            throw new IndexOutOfBoundsException();
        }
        return $this->elements[$index];
    }

    public function getIterator()
    {
        throw new NotImplementedException();
    }

    public function isEmpty()
    {
        return empty($this->elements);
    }

    public function lastIndexOf($o)
    {
        $reversed = array_reverse($this->elements);
        $return = array_search($o, $reversed, $this->class);
        if ($return !== false) {
            $return = $this->size() - $return - 1;
        }
        return $return;
    }

    public function size()
    {
        return count($this->elements);
    }

    public function removeAll($c)
    {
        throw new NotImplementedException();
    }

    public function removeElement($o)
    {
        $index = $this->indexOf($o);
        if ($index === false) {
            return null;
        }
        $this->remove($index);
        return true;
    }

    public function indexOf($o)
    {
        return array_search($o, $this->elements, $this->class);
    }

    public function remove($index)
    {
        if (!is_int($index)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($index)) {
            throw new IndexOutOfBoundsException();
        }

        // smazany prvek
        $removed = $this->elements[$index];

        // posune prvky
        for ($i = $index; $i < count($this->elements) - 1; $i++) {
            $this->elements[$i] = $this->elements[$i + 1];
        }

        // zrusi posledni prvek
        unset($this->elements[count($this->elements) - 1]);

        return $removed;
    }

    public function retainAll($c)
    {
        throw new NotImplementedException();
    }

    public function set($index, $element)
    {
        if (!is_int($index)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($index)) {
            throw new IndexOutOfBoundsException();
        }

        $return = $this->elements[$index];
        $this->elements[$index] = $element;

        return $return;
    }

    public function subList($fromIndex, $toIndex)
    {
        if (!is_int($fromIndex)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($fromIndex)) {
            throw new IndexOutOfBoundsException();
        }
        if (!is_int($toIndex)) {
            throw new IndexNotNummericException();
        }
        if ($this->outOfIndex($toIndex)) {
            throw new IndexOutOfBoundsException();
        }

        return new ArrayList(array_slice($this->elements, $fromIndex, $toIndex), $this->class);
    }

    public function toArray()
    {
        return $this->elements;
    }
}
