<?php

namespace IZON\DB\Factories;

use IZON\DB\Utils\ClassDescription;
use IZON\DB\Utils\PropertyDescriptions\AbstractPropertyDescription;

/**
 *
 * @package IZON\DB\Factories
 */
interface DescriptionFactoryInterface {

    /**
     * @param ClassDescription $classDescription
     * @param string $propertyName
     * @param string $columnName
     * @param string $columnReturnName
     * @param bool $notNull
     * @param array $additionalParameters
     * @return AbstractPropertyDescription
     */
    public function createPropertyDescription(
        ClassDescription $classDescription,
        string $propertyName,
        string $columnName,
        string $columnReturnName,
        bool $notNull,
        array $additionalParameters = []): AbstractPropertyDescription;
}
