<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use Exception;
use PDO;

use IZON\DB\Utils\ClassDescription;


/**
 * Popis data
 */
class ManyToOneDefinition extends AbstractPropertyDescription {

    function __construct(ClassDescription $classDescription, $propertyName, $columnName, $columnReturnName, $notNull, array $parameters) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "bigint";
        $this->pdoDataType = PDO::PARAM_INT;
    }

    public function parse($value, $object) {
        if($value == NULL) {
            if($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return NULL;
        }
        // NOTE: implement
    }

    public function serialize($value, $object) {
        if($value == NULL) {
            if($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return NULL;
        }
        
        // NOTE: implement
        
    }

    function getPdoDataType($value) {
        if($value == NULL)
            return PDO::PARAM_NULL;
        return $this->pdoDataType;
    }

}
