<?php

namespace IZON\DB;

use IZON\DB\QueryResult;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PageContent;
use IZON\DB\DBObject;

// TODO: asi zacit vynycovat aby metody update a save meli jako parametr objekt implementujici DBObject

/**
 * @template T of DBObject
 */
interface Dao {

    /**
     * loads objedct with provided id
     * @param mixed $id
     * @return T loaded object
     * @throws \Exception if sutch object isn't in db
     */
    public function load($id);

    /**
     * načte všechny objekty třídy
     * @return \IZON\DB\QueryResult<T>
    */
    public function loadAll();

    /**
     * najde vsechny objekty odpovidaji params poli
     * kde je klic jmeno promenne a hodnota je hodnota kterou nabyva
     * hodnoty se vazou pres and
     * @param array $params hodnoty jednotlivych property, ktere ma nabivat
     * @param array $orders podle jakych property se maji vysledky seradit, klice jsou nazvy property a hodnota je boolean ktery urcuje jestli se ma radit asc pokud je true nebo desc pokud je false
     * @return \IZON\DB\QueryResult<T>
     */
    public function find(array $params, array $orders = []);

    /**
     * provede update v db zadaného objektu
     * @param T $obj k updatování
     * @return int
    */
    public function update($obj);

    /**
     * uloží zadaný objekt do db
     * @param T $obj k uložení
     * @return int
    */
    public function save($obj);

    /**
     * smaže zadaný objekt z db
     * @param T|int $obj ke smazání
    */
    public function delete($obj);

    /**
     * vytvori PaginatorConfig pro paginator $paginatorName s konfiguraci, jak se maji prevadet parametry pro dany paginator
     * @param string $paginatorName
     * @param integer $maxPageSize maximalni velikost stranky
     * @return PaginatorConfig paginator config pro dany paginator
     */
    public function createPaginatorConfig($paginatorName, $maxPageSize = PaginatorConfig::DEFAULT_MAX_PAGE_SIZE);

    /**
     * vytvori defaultni strankovac
     * @param integer $maxPageSize maximalni velikost stranky
     * @return PaginatorConfig paginator config pro dany paginator
     */
    public function createDefaultPaginatorConfig($maxPageSize = PaginatorConfig::DEFAULT_MAX_PAGE_SIZE);

    /**
     * vrati obsah stranky s jejimi daty
     * ProductsPaginatorConfig musi mit jmeno:
     * ProductsPaginatorFactory a mit definovane metody count a create
     * @param PaginatorConfig $paginatorConfig konfiurace strankovace
     * @return PageContent vraci strankovac nastaveny podle pozadovaneho configu
    */
    public function paginate(PaginatorConfig $paginatorConfig);

    /**
     * vytvoří novou instanci třídy <Clazz>, pro kterou je dané
     * DAO vytvořené
     * @return T instance
    */
    public function create();

    /**
     * provede synchronizaci doposud nesynchronizovaných provedených
     * dotazů do databáze
    */
    public function flush();

    /**
     * zapocne transakci
     */
    public function beginTransaction();

    /**
     * commituje transakci
     */
    public function commit();

    /**
     * rollbackuje transakci
     */
    public function rollBack();
}
