<?php

namespace IZON\DB;

use IZON\DI\FactoryBean;
use IZON\Logs\Logger;
use Laminas\Code\Generator\ClassGenerator;
use Laminas\Code\Generator\MethodGenerator;
use Laminas\Code\Generator\ParameterGenerator;
use ReflectionClass;

/**
 * Slouzi k vytvoreni daa
 * rename to TransactionManagementFactoryObject
 */
class TransactionManagementFactoryBean implements FactoryBean {

    /**
     * @var DBConnection
     */
    protected $connection;

    /**
     * na jaky objekt se maji preposilat pozadavky
     * @var object
     */
    protected $proxyObject;

    /**
     *
     * @var Logger
     */
    private $log;


    public function __construct(DBConnection $connection, $proxyObject) {
        $this->connection = $connection;
        $this->proxyObject = $proxyObject;

        $this->log = Logger::getLogger(self::class);
    }


    public function getObject() {
        $objectReflectionClass = new ReflectionClass(get_class($this->proxyObject)); // class Foo of namespace A

        $objectName = $objectReflectionClass->getName()."TxProxy";

        // trida jeste neexistuje je ji treba vytvorit a ninicializovat
        if(!class_exists($objectName)) {
            $implCacheFileName = $this->connection->getTransactionProxyImplCacheDir() ."/". str_replace('\\', '/', $objectName) .".php";
            $fileLastModified = filemtime($objectReflectionClass->getFileName());

            if( $this->connection->getTransactionProxyImplCacheDir() != NULL // je definovan adresar kam cachovat daa
                && file_exists($implCacheFileName) // uz existuje vygenerovane dao
                && $fileLastModified <= filemtime($implCacheFileName) ) { // cache je novejsi nez soubor ve kterem byl vygenerovan
                // vem dao z cache
                require $implCacheFileName;
            } else {

                // TODO: pridat cashovani vytvorene tridy
                $parentClass = "\\".get_class($this->proxyObject);

                $parentInterfaces = $objectReflectionClass->getInterfaceNames();
                $implInterfaces = [];
                foreach($objectReflectionClass->getInterfaces() as $inedx => $interface) {
                    $implInterfaces[$inedx] = "\\".$interface->name;
                }

                $class = new ClassGenerator(
                    $objectName,
                    $objectReflectionClass->getNamespaceName(),
                    null,
                    $parentClass, $implInterfaces
                );

                // vytvori konstruktor pro predani parametru
                $method = new MethodGenerator(
                    "__construct",
                    [new ParameterGenerator("connection", "\IZON\DB\DBConnection"), "proxyObject"]
                );
                $method->setBody('$this->connection = $connection; $this->proxyObject = $proxyObject;');
                $class->addMethodFromGenerator($method);

                // prochaci metody rozhrani daa
                foreach($objectReflectionClass->getMethods() as $method) {
                    if($method->name == '__construct') {
                        continue;
                    }

                    $declaringClass = $method->getDeclaringClass();
                    // pridat metodu
                    $parameters = [];
                    $paransNames = [];
                    foreach($method->getParameters() as $parameter) {
                        /* @var $parameter \ReflectionParameter */
                        $parameterTypeName = null;

                        // najit typ parametru
                        if($parameter->hasType()) {
                            $parameterTypeName = $parameter->getType()->allowsNull() ? '?' : '';
                            $parameterTypeName .= $parameter->getType()->getName();
                        }

                        $paramGenerator = new ParameterGenerator($parameter->getName(), $parameterTypeName);
                        if($parameter->isDefaultValueAvailable()) {
                            $paramGenerator->setDefaultValue($parameter->getDefaultValue());
                        }
                        if($parameter->isPassedByReference()) {
                            $paramGenerator->setPassedByReference(true);
                        }
                        $parameters[] = $paramGenerator;
                        $paransNames[] = '$'.$parameter->getName();
                    }

                    // vytvori dummy metody pro volani
                    $generatedMethod = new MethodGenerator($method->getName(), $parameters);

                    /** @var \ReflectionNamedType $returnType */
                    $returnType = $method->getReturnType();

                    if($returnType !== null) {
                        $returnTypeName = $returnType->allowsNull() ? '?' : '';
                        if(!$returnType->isBuiltin()) {
                            $returnTypeName .= '\\'.$returnType->getName();
                        } else {
                            $returnTypeName .= $returnType->getName();
                        }
                        $generatedMethod->setReturnType($returnTypeName);
                    }

                    $generatedMethod->setBody(
                        ' $pdo = $this->connection->getPDO(); '
                        .' $pdo->beginTransaction(); '
                        .' try { '
                        .' $ret = $this->proxyObject->'.$method->getName().'('.implode(", ", $paransNames).');'
                        .' $pdo->commit(); '
                        .(($returnType !== null ? $returnType->getName() : null) !== 'void' ? ' return $ret; ' : '')
                        .' } catch (\Throwable $e) {'
                        .' $pdo->rollBack(); '
                        .' throw $e; '
                        .' }'
                    );
                    $class->addMethodFromGenerator($generatedMethod);
                }

                $gemenratd = $class->generate();

                $this->log->info("Generated class: ".print_r($gemenratd, true));

                eval($gemenratd);

                if($this->connection->getTransactionProxyImplCacheDir() != NULL) { // je nastaven adresar pro cache
                    // zapsat do cache
                    $implCacheDirName = dirname($implCacheFileName);
                    if(!file_exists($implCacheDirName)) { // neni soubor do ktereho se ma zapsat
                        if(!@mkdir($implCacheDirName, 0777, true)) { // nevyhazovat warning pokud jiz adresar existuje
                            $this->log->warning(
                                "Nepodarilo se vytvorit adresar $implCacheDirName pro cache transaction proxy $objectName"
                            );
                        }
                    }
                    if(!file_put_contents($implCacheFileName, "<?php\r\n".$gemenratd, LOCK_EX)) {
                        $this->log->warning(
                            "Nepodarilo se zapsat cache $objectName transaction proxy souboru $implCacheFileName"
                        );
                    }
                    if(file_exists($implCacheFileName)) {
                        chmod($implCacheFileName, 0777);
                    }
                }
            }
        }

        $object = new $objectName($this->connection, $this->proxyObject);
        return $object;
    }

}
