<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \Exception;

use IZON\IO\Image;

use IZON\DB\Utils\ClassDescription;

/**
 * Popis souboru
 */
class ImageDescription extends FileDescription {
    
    
    /**
     * 
     * @param string $propertyName
     * @param string $columnName
     * @param boolean $notNull
     * @param array $parameters
     */
    function __construct(ClassDescription $classDescription,
                            $propertyName, $columnName, $columnReturnName, $notNull, array $parameters = []) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);
        
        $this->dbDataType = Image::class;
    }
    
    public function parse($value, $object) {
        if ($value == NULL) {
            if ($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return NULL;
        }

        $storageDir = $this->getStorageDir($object);
        $fileName = $storageDir . "/" . $value;
        if ( !file_exists($fileName) ) {
            $this->log->error("Db file " . $fileName . " isn't present on filesystem.");
            
            if( file_exists($this->missingFileFilePath) ) {
                $fileName = $this->missingFileFilePath;
            } else {
                $this->log->error("Rplacement form missing file " . $this->missingFileFilePath . " isn't present on filesystem.");
                return NULL;
            }
            
        }
        // create file
        $file = new Image($fileName);

        return $file;
    }

}
