<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \Exception;
use \PDO;

use IZON\Utils\Date;

use IZON\DB\Utils\ClassDescription;

/**
 * Popis data
 */
class DateTimeDescription extends AbstractPropertyDescription {
    
    protected $format = "Y-m-d H:i:s";
    
    function __construct(ClassDescription $classDesctiption,
                            $propertyName, $columnName, $columnReturnName, $notNull, array $parameters) {
        parent::__construct($classDesctiption, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);
        
        $this->dbDataType = "date";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_TIMESTAMP;
    }

    public function parse($value, $object) {
        if(  $value == NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        $date = Date::createFromFormat($this->format, $value);
        return $date;
    }

    public function serialize($value, $object) {
        if(  $value == NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        if( !($value instanceof Date) ) {
            throw new Exception("Hodnota musi byt null nebo IZON\Utils\Date");
        }
        
        $serializedString = $value->format($this->format);
        return $serializedString;
    }

    function getPdoDataType($value) {
        if( $value == NULL )
            return PDO::PARAM_NULL;
        return $this->pdoDataType;
    }
}
