<?php

namespace IZON\DB;

use \ReflectionClass;

use Zend\Code\Generator\ClassGenerator;
use Zend\Code\Generator\MethodGenerator;
use Zend\Code\Generator\ParameterGenerator;

use IZON\DB\DBConnection;

use IZON\Logs\Logger;

use IZON\DI\FactoryBean;

/**
 * Slouzi k vytvoreni daa
 * rename to TransactionManagementFactoryObject
 */
class TransactionManagementFactoryBean implements FactoryBean {
    
    /**
     * @var DBConnection 
     */
    protected $connection;

    /**
     * na jaky objekt se maji preposilat pozadavky
     * @var object 
     */
    protected $proxyObject;
    
    /**
     * 
     * @var Logger 
     */
    private $log;
    
    
    public function __construct(DBConnection $connection, $proxyObject) {
        $this->connection = $connection;
        $this->proxyObject = $proxyObject;
        
        $this->log = Logger::getLogger(self::class);
    }
    
    
    public function getObject() {
        $objectReflectionClass = new ReflectionClass(get_class($this->proxyObject)); // class Foo of namespace A
        
        $objectName = $objectReflectionClass->getName() ."TxProxy";
        
        // trida jeste neexistuje je ji treba vytvorit a ninicializovat
        if( !class_exists($objectName) ) {
            // TODO: pridat cashovani vytvorene tridy
            $parentClass = "\\". get_class($this->proxyObject);
            
            $parentInterfaces = $objectReflectionClass->getInterfaceNames();
            $implInterfaces = [];
            foreach($objectReflectionClass->getInterfaces() as $inedx => $interface) {
                $implInterfaces[$inedx] = "\\". $interface->name;
            }
            
            $class = new ClassGenerator($objectName, 
                            $objectReflectionClass->getNamespaceName(), 
                            null, 
                            $parentClass, $implInterfaces);
            
            // vytvori konstruktor pro predani parametru
            $method = new MethodGenerator("__construct", [new ParameterGenerator("connection", "\IZON\DB\DBConnection"), "proxyObject"]);
            $method->setBody('$this->connection = $connection; $this->proxyObject = $proxyObject;');
             $class->addMethodFromGenerator($method);
            
            // prochaci metody rozhrani daa
            foreach($objectReflectionClass->getMethods() as $method) {
                if( $method->name == '__construct' ) {
                    continue;
                }
                
                $declaringClass = $method->getDeclaringClass();
                // pridat metodu
                $parameters = [];
                $paransNames = [];
                foreach( $method->getParameters() as $parameter ) {
                    /* @var $parameter \ReflectionParameter */
                    $parameterTypeName = null;
                    
                    // najit typ parametru
                    if($parameter->hasType()) {
                            $parameterTypeName = $parameter->getType()->getName();
                    }
                    
                    $paramGenerator = new ParameterGenerator($parameter->getName(), $parameterTypeName);
                    if( $parameter->isDefaultValueAvailable() ) {
                        $paramGenerator->setDefaultValue($parameter->getDefaultValue());
                    }
                    if( $parameter->isPassedByReference() ) {
                        $paramGenerator->setPassedByReference(true);
                    }
                    $parameters[] = $paramGenerator;
                    $paransNames[] = '$'. $parameter->getName();
                }
                //
                $returnType = $method->getReturnType();
                
                // vytvori dummy metody pro volani
                // TODO: umoznit volani callable se zvlastni obsluhou transakci
                $method = new MethodGenerator($method->getName(), $parameters);
                $method->setReturnType($returnType);
                $method->setBody(' $pdo = $this->connection->getPDO(); '
                        .' $pdo->beginTransaction(); '
                        .' try { '
                            .' $ret = $this->proxyObject->'. $method->getName() .'('. implode(", ", $paransNames) .');'
                            .' $pdo->commit(); '
                            .' return $ret; '
                        .' } catch (\Exception $e) {'
                            .' $pdo->rollBack(); '
                            .' throw $e; '
                        .' }');
                $class->addMethodFromGenerator($method);
            }

            $gemenratd = $class->generate();
            
            $this->log->info("Generated class: ". print_r($gemenratd, true));
            
//            var_dump($gemenratd);
//            echo "<pre>". print_r($gemenratd, true) ."</pre>";
            eval($gemenratd);
        }

        $object = new $objectName($this->connection, $this->proxyObject);
        return $object;
    }

}
