<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \PDO;
use \Exception;

use IZON\DB\Utils\ClassDescription;

/**
 * Popis data
 */
class FloatDescription extends AbstractPropertyDescription {
    
   function __construct(ClassDescription $classDesctiption,
                            $propertyName, $columnName, $columnReturnName, $notNull, array $parameters) {
        parent::__construct($classDesctiption, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);
        
        $this->dbDataType = "float";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_FLOAT;
    }

    public function parse($value, $object) {
        if(  $value === NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        $number = doubleval($value);
        return $number;
    }

    public function serialize($value, $object) {
        if(  $value === NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        // TODO: resit floaty nejak lepe nez menit carku za tecku
        return "". str_replace(",", ".", $value);
    }

    function getPdoDataType($value) {
        if( $value === NULL ) {
            return PDO::PARAM_NULL;
        }
        return $this->pdoDataType;
    }
}
