<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use IZON\DB\Utils\ClassDescription;

class JsonDescription extends AbstractPropertyDescription {

    protected $parseAssociative = true;

    public function __construct(
        ClassDescription $classDescription,
        $propertyName,
        $columnName,
        $columnReturnName,
        $notNull,
        array $parameters
    ) {
        parent::__construct($classDescription, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);
        $this->parseAssociative = $this->extractParameter("parseAssociative", $parameters, false, true);
        $this->dbDataType = "json";
        $this->pdoDataType = \PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_CHAR_VARYING;
    }


    public function parse($value, $object) {
        return \json_decode($value, $this->parseAssociative);
    }

    public function serialize($value, $object) {
        return \json_encode($value, JSON_UNESCAPED_UNICODE);
    }

}
