<?php

namespace IZON\DB\Collections;

use IZON\Lang\NotImplementedException;
use IZON\Utils\Collection;
use IZON\Utils\OrderedSet;

/**
 * Mnozina ktera se pouziva pro ukladani dat do db
 */
class PersistentOrderedSet extends OrderedSet {
    
    /**
     * 
     * @param Collection|array $elements elementy seznamu nebo trida, ktara se ma v seznamu ukladat
     * @param string $class trida, ktara se ma v seznamu ukladat
     */
    public function __construct($elements = [], $class = NULL) {
        parent::__construct($elements, $class);
    }
    
    public function add($e) {
        if( $this->contains($e) ) {
            return false;
        } else {
            $elements[] = $e;
            return true;
        }
    }

    public function addAll($c) {
        throw new NotImplementedException();
    }

    public function clear() {
        $this->elements = [];
    }

    public function contains($o) {
        return in_array($o, $this->elements, $this->class);
    }

    public function containsAll($c) {
        throw new NotImplementedException();
    }

    public function getIterator() {
        
    }

    public function isEmpty() {
        return empty($this->elements);
    }

    public function removeAll($c) {
        throw new NotImplementedException();
    }

    public function removeElement($o) {
        $index = array_search($o, $this->elements, $this->class);
        if( $index === FALSE) {
            return FALSE;
        }
         // posune prvky
        for($i = $index; $i < count($this->elements)-1; $i++ ) {
            $this->elements[$i] = $this->elements[$i+1];
        }

        // zrusi posledni prvek
        unset($this->elements[count($this->elements)-1]);
        
        return TRUE;
    }

    public function retainAll($c) {
        throw new NotImplementedException();
    }

    public function size() {
        return count($this->elements);
    }

    public function toArray() {
        return $this->elements;
    }
}
