<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \PDO;
use \Exception;
use IZON\DB\Utils\ClassDescription;

/**
 * description of text field
 */
class TextDescription extends AbstractPropertyDescription {
    
    /**
     * @var integer max length of string 
     */
    protected $maxLength = PHP_INT_MAX;

    
    function __construct(ClassDescription $classDesctiption, $propertyName, $columnName, $columnReturnName, $notNull, array $parameters) {
        parent::__construct($classDesctiption, $propertyName, $columnName, $columnReturnName, $notNull, $parameters);

        $this->dbDataType = "text";
        $this->pdoDataType = PDO::PARAM_STR;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_CHAR_VARYING;
    }

    public function parse($value, $object) {
        if($value === NULL) {
            if($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return NULL;
        }

        if(mb_strlen($value) > $this->maxLength) {
            throw new Exception("" . $this->getPropertyName() . " nesmi byt delsi nez " . $this->maxLength);
        }

        $date = $value;
        return $date;
    }

    public function serialize($value, $object) {
        if($value === NULL) {
            if($this->getNotNull()) {
                throw new Exception("" . $this->getPropertyName() . " nesmi byt null");
            }
            return NULL;
        }

        if(mb_strlen($value) > $this->maxLength) {
            throw new Exception("" . $this->getPropertyName() . " nesmi byt delsi nez " . $this->maxLength);
        }

        return $value;
    }

    function getPdoDataType($value) {
        if($value === NULL)
            return PDO::PARAM_NULL;
        return $this->pdoDataType;
    }

    function getMaxLength() {
        return $this->maxLength;
    }

    function setMaxLength($maxLength) {
        $this->maxLength = $maxLength;
    }

}
