<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \Exception;

use \IZON\DB\Utils\ClassDescription;

/**
 * NOTE: probbably add interface
 * Slouzik popisu property a k jejimu parsovani tam a zpet z php do PDO
 */
abstract class AbstractPropertyDescription {
    
    /**
     * retezec s promenlivou delkou
     */
    const ANSI_DATA_TYPE_CHAR_VARYING = "varchar";

    /**
     * celociselny typ
     */
    const ANSI_DATA_TYPE_INT = "int";
    
    /**
     * boolovsky datovy typ
     */
    const ANSI_DATA_TYPE_BOOLEAN = "boolean";
    
    /**
     * typ s plovouci desetinou carkou
     */
    const ANSI_DATA_TYPE_FLOAT = "float";
    
    /**
     * typ datum
     */
    const ANSI_DATA_TYPE_DATE = "date";
    
    /**
     * typ cas
     */
    const ANSI_DATA_TYPE_TIME = "time";
    
    /**
     * typ s datem a casem
     */
    const ANSI_DATA_TYPE_TIMESTAMP = "timestamp";
    
    /**
     * bitovy string s promenilovou delkou
     */
    const ANSI_DATA_TYPE_BIT_VARYING = "bitvarying";


    /**
     * k jake tride se tato PropertyDescription vaze
     * @var ClassDescription; 
     */
    protected $classDesctiption;

    /**
     * nazev property
     * @var string 
     */
    protected $propertyName;
    
    /**
     * nazep sloupce v db na ktery se ma mapovat
     * @var string 
     */
    protected $columnName;
    
    /**
     *jak se ma jmenovat hodnota v poli vracenem na dtaz z db
     * @var string
     */
    protected $columnReturnName;


    /**
     * jestli muze byt property null
     * @var boolean 
     */
    protected $notNull = false;


    /**
     * databazovy data typ
     * @var string 
     */
    protected $dbDataType;
    
    /**
     * datovy typ z ansi/iso standartu
     * vycet:
     * http://www.moreprocess.com/database/sql/data-types-in-sql-defined-by-ansiiso
     * http://www.w3schools.com/sql/sql_datatypes_general.asp
     * @var string
     */
    protected $ansiDataType;
    
    /**
     * @var integer type represented in pdo (PDO::PARAM_STR, ...)
     */
    protected $pdoDataType;
    
    /**
     * 
     * @param ClassDescription $classDesctiption popis tridy, ke ktere se toto property vaze
     * @param string $propertyName jak se jmenuje property v objektu
     * @param string $columnName jak se jmenuje sloupecek v db
     * @param string $columnReturnName jak se vrati sloupecek v poli z db
     * @param boolean $notNull
     */
    function __construct(ClassDescription $classDesctiption,
                            $propertyName, 
                            $columnName,
                            $columnReturnName,
                            $notNull,
                            array $parameters) {
        $this->classDesctiption = $classDesctiption;
        $this->propertyName = $propertyName;
        $this->columnName = $columnName;
        $this->columnReturnName = $columnReturnName;
        $this->notNull = $notNull;
        
        $parameters;
    }
    
    /**
     * prevede hodnotu ziskanou z db na hodnotu v php
     * var $value hodnota z db, ktera se ma parsovat do php
     * var object $object do ktereho objektu se ma parsovat
     */
    public abstract function parse($value, $object);
    
    /**
     * pro hodnotu v php vrati hodnotu pouzivanou v sql
     * var $value hodnota, ktera se am parsovat do db
     * var object $object objekt z ktereho se ma hodnota parsovat
     */
    public abstract function serialize($value, $object);
    
    
    function getPropertyName() {
        return $this->propertyName;
    }

    function getColumnName() {
        return $this->columnName;
    }
    
    function getNotNull() {
        return $this->notNull;
    }

    function getDbDataType() {
        return $this->dbDataType;
    }
    
    function getAnsiDataType() {
        return $this->ansiDataType;
    }
        
    function getPdoDataType($value) {
        return $this->pdoDataType;
    }
    
    function getColumnReturnName() {
        return $this->columnReturnName;
    }    
    
    /**
     * extrahuje param
     * @param string $parameterName
     * @param array $definitions
     * @param boolean $raiseExceprionIfNotPresent
     * @param mixed $default
     * @throws Exception
     */
    protected function extractParameter($parameterName, 
                                            array &$definitions, // pass by reference to unset work properly
                                            $raiseExceprionIfNotPresent = false,
                                            $default = NULL) {
        $retval = $default;
        if( isset($definitions[$parameterName]) ) {
            $retval = $definitions[$parameterName];
            unset($definitions[$parameterName]);
        } else if( $raiseExceprionIfNotPresent ) {
            $e = new Exception("Definition $parameterName not set");
            throw $e;
        }
        return $retval;
    }
    
    function __toString() {
        return "[". get_class($this) ."]";
    }
}
