<?php
/**
 * funkce pouzivane pri konfiguraci Databazovych objektu
 * 
 * melo by vychazet z https://docs.djangoproject.com/en/1.8/ref/models/fields/#field-types
 */
namespace IZON\DB;

use DI\Definition\EntryReference;
use IZON\DB\Definitions\BooleanDefinition;
use IZON\DB\Definitions\CharDefinition;
use IZON\DB\Definitions\DateDefinition;
use IZON\DB\Definitions\DateTimeDefinition;
use IZON\DB\Definitions\FileDefinition;
use IZON\DB\Definitions\FloatDefinition;
use IZON\DB\Definitions\ImageDefinition;
use IZON\DB\Definitions\IntegerDefinition;
use IZON\DB\Definitions\TimeDefinition;
use IZON\DB\Definitions\TransientDefinition;
use function IZON\DI\link;

if (! function_exists('IZON\DB\charField')) {
    /**
     * definice stringoveho pole
     * @param array $definitions
     * @return CharDefinition
     */
    function charField($definitions) {
        return new CharDefinition($definitions);
    }
}

if (! function_exists('IZON\DB\integerField')) {
    /**
     * definice stringoveho pole
     * @param array $definitions
     * @return IntegerDefinition
     */
    function integerField($definitions) {
        return new IntegerDefinition($definitions);
    }
}

if (! function_exists('IZON\DB\floatField')) {
    /**
     * definice floatoveho pole
     * @param array $definitions
     * @return FloatDefinition
     */
    function floatField($definitions) {
        return new FloatDefinition($definitions);
    }
}


if (! function_exists('IZON\DB\transientField')) {
    /**
     * nemapovane pole
     * @return TransientDefinition
     */
    function transientField() {
        return new TransientDefinition();
    }
}

if (! function_exists('IZON\DB\idField')) {

    /**
     * Helper for referencing another container entry in an object definition.
     *
     * @param string $entryName            
     *
     * @return EntryReference
     */
    function idField($entryName) {
        return link($entryName);
    }
}

if ( !function_exists('IZON\DB\dateTimeField') ) {
    function dateTimeField($definitions) {
        return new DateTimeDefinition($definitions);
    }
}

if ( !function_exists('IZON\DB\dateField') ) {
    function dateField($definitions) {
        return new DateDefinition($definitions);
    }
}

if ( !function_exists('IZON\DB\timeField') ) {
    function timeField($definitions) {
        return new TimeDefinition($definitions);
    }
}

if ( !function_exists('IZON\DB\fileField') ) {
    function fileField($definitions) {
        return new FileDefinition($definitions);
    }
}

if ( !function_exists('IZON\DB\imageField') ) {
    function imageField($definitions) {
        return new ImageDefinition($definitions);
    }
}

if ( !function_exists('IZON\DB\booleanField') ) {
    function booleanField($definitions) {
        return new BooleanDefinition($definitions);
    }
}