<?php

namespace IZON\DB;

use Exception;

/**
 * alias for database table
 *
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class TableAlias {

    /**
     *
     * @var QueryHelpers
     */
    protected $queryHelpers;

    /**
     *
     * @var string
     */
    protected $alias;

    /**
     *
     * @var string
     */
    protected $className;

    /**
     * when class name is null, uses current domain
     * 
     * @param \IZON\DB\QueryHelpers $queryHelpers
     * @param string $alias
     * @param string $className
     */
    public function __construct(QueryHelpers $queryHelpers, $alias, $className = null) {
        $this->queryHelpers = $queryHelpers;
        $this->alias = $alias;
        $this->className = $className;
    }

    /**
     * returns name of column for specified property of object
     * @param string $propertyName
     * @return string aliased column name
     */
    public function getColumnName($propertyName) {
        if (is_null($this->className)) {
            return $this->queryHelpers->getCoumnName($propertyName, $this->alias);
        } else {
            return $this->queryHelpers->getClassCoumnName($this->className, $propertyName, $this->alias);
        }
    }

    /**
     * 
     * @return string aliased table name
     */
    public function getTableName() {
        if (is_null($this->className)) {
            return $this->queryHelpers->getTableName($this->alias);
        } else {
            return $this->queryHelpers->getClassTableName($this->className, $this->alias);
        }
    }

    /**
     * @depracted use getClassProperties as it matches use more precisely
     * @return string aliased column names for select, only work when className is null
     * @throws Exception
     */
    public function getColumnNames() {
        if (is_null($this->className)) {
            return $this->queryHelpers->getClassProperties($this->alias);
        } else {
            throw new Exception('cannot be used for different table');
        }
    }

    /**
     * 
     * @return string aliased column names for select, only work when className is null, formt $alias.column_name1, $alias.column_name2 kde column_name odpovida $propertyName
     * @throws Exception
     */
    public function getClassProperties() {
        if (is_null($this->className)) {
            return $this->queryHelpers->getClassProperties($this->alias);
        } else {
            throw new Exception('cannot be used for different table');
        }
    }

    /**
     * returns part for group by "$alias.conum_name1, $alias.conum_name2, ... " 
     * @param array $properties list of properties
     * @param boolena $excludeProperties if include or exclude properties specified in $properties
     * @param string $alias
     * @throws Exception
     */
    public function getGroupByProperties(array $propertieNames = [], $excludeProperties = true) {
        if (is_null($this->className)) {
            return $this->queryHelpers->getGroupByProperties($this->alias, $propertieNames, $excludeProperties);
        } else {
            throw new Exception('cannot be used for different table');
        }
    }
}
