<?php

namespace IZON\DB;

use IZON\DB\QueryResult;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PageContent;
use IZON\DB\DBObject;

// TODO: asi zacit vynycovat aby metody update a save meli jako parametr objekt implementujici DBObject
interface Dao {
    
    /**
     * načte objekt se zadaným id
     * @param id id, podle kterého má být objekt načten
     * @return DBObject načtený objekt
     */
    public function load($id);
    
    /**
     * načte všechny objekty třídy
     * @return \IZON\DB\QueryResult
    */
    public function loadAll();
    
    /**
     * najde vsechny objekty odpovidaji params poli
     * kde je klic jmeno promenne a hodnota je hodnota kterou nabyva
     * hodnoty se vazou pres and
     * @param array $params hodnoty jednotlivych property, ktere ma nabivat
     * @param array $orders podle jakych property se maji vysledky seradit, klice jsou nazvy property a hodnota je boolean ktery urcuje jestli se ma radit asc pokud je true nebo desc pokud je false
     * @return \IZON\DB\QueryResult
     */
    public function find(array $params, array $orders = []);

    /**
     * provede update v db zadaného objektu
     * @param $obj DBObject k updatování
     * @return int
    */
    public function update($obj);
    
    /**
     * uloží zadaný objekt do db
     * @param $obj DBObject k uložení
     * @return integer
    */
    public function save($obj);
    
    /**
     * smaže zadaný objekt z db
     * @param $obj DBObject ke smazání
     * @return void
    */
    public function delete($obj);
    
    /**
     * vytvori PaginatorConfig pro paginator $paginatorName s konfiguraci, jak se maji prevadet parametry pro dany paginator
     * @param string $paginatorName
     * @param integer $maxPageSize maximalni velikost stranky
     * @return PaginatorConfig paginator config pro dany paginator
     */
    public function createPaginatorConfig($paginatorName, $maxPageSize = PaginatorConfig::DEFAULT_MAX_PAGE_SIZE);

    /**
     * vytvori defaultni strankovac
     * @param integer $maxPageSize maximalni velikost stranky
     * @return PaginatorConfig paginator config pro dany paginator
     */
    public function createDefaultPaginatorConfig($maxPageSize = PaginatorConfig::DEFAULT_MAX_PAGE_SIZE);
    
    /**
     * vrati obsah stranky s jejimi daty
     * ProductsPaginatorConfig musi mit jmeno:
     * ProductsPaginatorFactory a mit definovane metody count a create
     * @param $paginatorConfig PaginatorConfig konfiurace strankovace
     * @return PageContent vraci strankovac nastaveny podle pozadovaneho configu
    */
    public function paginate(PaginatorConfig $config);
    
    /**
     * najde objekty se zadanou hodnotou property
     * @param propertyName
     * @param value
     * @return \IZON\DB\QueryResult
    */
//    public function findBy(String $propertyName, Object $value);
    
    /**
     * vytvoří novou instanci třídy <Clazz>, pro kterou je dané
     * DAO vytvořené
     * @return DBObject instance
    */
    public function create();
    
    /**
     * provede synchronizaci doposud nesynchronizovaných provedených
     * dotazů do databáze
    */
    public function flush();
    
    /**
     * zapocne transakci
     */
    public function beginTransaction();
    
    /**
     * commituje transakci
     */
    public function commit();
    
    /**
     * rollbackuje transakci
     */
    public function rollBack();
}