<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\DB\Collections;

use \IZON\Utils\ArrayList;

use \IZON\Lang\IndexNotNummericException;
use \IZON\Lang\IndexOutOfBoundsException;
use \IZON\Lang\NotImplementedException;

/**
 * pouziva pro ukladani dat do db
 */
class PersistentArrayList implements ArrayList {
    
    
    
    /**
     * 
     * @param Collection|array|class $elements elementy seznamu nebo trida, ktara se ma v seznamu ukladat
     * @param class $class trida, ktara se ma v seznamu ukladat
     */
    public function __construct($elements = [], $class = NULL) {
        if($class !== NULL) {
            if( !class_exists($class) ) {
                new $class(); // moznaradeji vyhazovat vyjimku ze trida neexistuje
            }
        }
        if($elements !== NULL) {
            if( class_exists($elements) ) {
                $class = $elements;
                $elements = [];
            } else {
                if( $elements instanceof Collection ) {
                    $elements = $elements->toArray();
                }
                if( !is_array($elements) ) {
                    throw new Exception("$elements musi by array nebo instance Collection");
                }
            }
        }
        
        $this->elements = $elements;
        $this->class = $class;
    }

    public function add($element, $index = FALSE) {
        if($index === FALSE) {
            $this->elements[] = $element;
            return TRUE;
        }
        if( !is_int($index) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($index) ) {
            throw new IndexOutOfBoundsException();
        }
        
        // posune prvky
        for($i = count($this->elements)-1; $i > $index; $i-- ) {
            $this->elements[$i+1] = $this->elements[$i];
        }
        $this->elements[$index] = $element;
        return TRUE;
    }

    public function addAll($c) {
         throw new NotImplementedException();
    }

    public function clear() {
        $this->elements = [];
    }

    public function contains($o) {
        return in_array($o, $this->elements, $this->class);
    }

    public function containsAll($c) {
        throw new NotImplementedException();
    }

    public function get($index) {
        if( !is_int($index) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($index) ) {
            throw new IndexOutOfBoundsException();
        }
        return $this->elements[$index];
    }
    
    public function getIterator() {
        throw new NotImplementedException();
    }

    public function indexOf($o) {
        return array_search($o, $this->elements, $this->class);
    }

    public function isEmpty() {
        return empty($this->elements);
    }

    public function lastIndexOf($o) {
        $reversed = array_reverse($this->elements);
        $return =  array_search($o, $reversed, $this->class);
        if( $return !== FALSE) {
            $return = $this->size() - $return - 1;
        }
        return $return;
    }

    public function remove($index) {
        if( !is_int($index) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($index) ) {
            throw new IndexOutOfBoundsException();
        }
            
        // smazany prvek
        $removed = $this->elements[$index];

        // posune prvky
        for($i = $index; $i < count($this->elements)-1; $i++ ) {
            $this->elements[$i] = $this->elements[$i+1];
        }

        // zrusi posledni prvek
        unset($this->elements[count($this->elements)-1]);

        return $removed;
    }

    public function removeAll($c) {
         throw new NotImplementedException();
    }

    public function removeElement($o) {
        $index = $this->indexOf($o);
        if( $index === FALSE) {
            return NULL;
        }
        $this->remove($index);
        return TRUE;
    }

    public function retainAll($c) {
        throw new NotImplementedException();
    }

    public function set($index, $element) {
        if( !is_int($index) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($index) ) {
            throw new IndexOutOfBoundsException();
        }
        
        $return = $this->elements[$index];
        $this->elements[$index] = $element;
        
        return $return;
    }

    public function size() {
        return count($this->elements);
    }

    public function subList($fromIndex, $toIndex) {
        if( !is_int($fromIndex) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($fromIndex) ) {
            throw new IndexOutOfBoundsException();
        }
        if( !is_int($toIndex) ) {
            throw new IndexNotNummericException();
        }
        if( outOfIndex($toIndex) ) {
            throw new IndexOutOfBoundsException();
        }
        
        return new ArrayList(array_slice($this->elements, $fromIndex, $toIndex), $this->class);
    }

    public function toArray() {
        return $this->elements;
    }
    
    protected function outOfIndex($index) {
        return $index < 0
                || $index >= count($this->elements);
    }

}
