<?php
/**
 * provadi testy dependency injection
 */

use DI\ContainerBuilder;
use \Test\Domain\Question;
use \Test\Dao\QuestionDao;
use \Test\Dao\ExaminationDateDao;
use \IZON\DB\Impl\DBConnectionMySQLImpl;
use \IZON\DB\Impl\DaoImpl;
use \Test\TestService;

/**
 * popis autoloadingu // http://www.sitepoint.com/battle-autoloaders-psr-0-vs-psr-4/
 */
$loader = require '../../../htdocs/vendor/autoload.php';
$loader->addPsr4('Test\\', __DIR__ .'/Test');
$loader->addPsr4('Test\\', __DIR__ .'/../DI/Test');
//$loader->addPsr4('Test\\', __DIR__ .'/Test');
$loader->add('IZON\\DI\\', __DIR__ .'/../../../htdocs/lib/DI/classes');
$loader->add('IZON\\DB\\', __DIR__ .'/../../../htdocs/lib/DB/classes');
$loader->add('IZON\\Utils\\', __DIR__ .'/../../../htdocs/lib/Utils/classes');

require_once __DIR__ .'/../../../htdocs/lib/DB/classes/IZON/DB/functions.php';

function obj2array ( &$Instance ) {
    $clone = (array) $Instance;
    $rtn = array ();
    $rtn['___SOURCE_KEYS_'] = $clone;

    while ( list ($key, $value) = each ($clone) ) {
        $aux = explode ("\0", $key);
        $newkey = $aux[count($aux)-1];
        $rtn[$newkey] = &$rtn['___SOURCE_KEYS_'][$key];
    }

    return $rtn;
}

$testDbObject = new Question();
//$testDbObject->setId(13);
$testDbObject->setDescription("sdetyuiooppp");
$testDbObject->setName(12.33);
$testDbObject->setSubjectId(1);

$connection = new DBConnectionMySQLImpl('localhost', 'test', 'root', 'Mm721215');
$namingStrategy = new \IZON\DB\Impl\DefaultNamingStrategy();
$description = new IZON\DB\Utils\ClassDescription($connection, Question::class);

/*
$arr = obj2array($testDbObject);
var_dump($arr);
echo $arr['id'] ." => ". gettype($arr['id']) ."\n";
echo $arr['description'] ." => ". gettype($arr['description']) ."\n";
echo $arr['name'] ." => ". gettype($arr['name']) ."\n";

echo method_exists('Test\Domain\TestDbObject', "__id") ."\n";
echo property_exists('Test\Domain\TestDbObject', "id") ."\n";

var_dump($testDbObject->getObjectProperties());
var_dump($testDbObject->getPropertyAnotation("id"));
*/


$factory = new \IZON\DB\DaoFactoryBean($connection, QuestionDao::class);
/** @var QuestionDao **/
$dao = $factory->getObject();

$obj = $dao->load(29);
var_dump($obj);

$obj = $dao->load(30);
var_dump($obj);

$subjects = $dao->findSubjectQuestions(11);
$subjects->setMaxResults(5);

$res = $subjects->listResult();
var_dump($res);


$factory = new \IZON\DB\DaoFactoryBean($connection, ExaminationDateDao::class);
$dao = $factory->getObject();
$obj = $dao->load(8);
var_dump($obj);

return;

/*
//
$id = $dao->save($testDbObject);
echo $id ."\n";
$testDbObject->setId($id);

$testDbObject->setName("blah");
$dao->update($testDbObject);
*/

//$dao->delete($testDbObject);
//$dao->delete(3);

///* @var Test\TestService */
//$testService = new TestService($dao);
///* @var Test\TestDbObject */
//$test = $testService->test();
//$test->getId();

try {
    $dbh = new PDO('mysql:host=localhost;dbname=test;charset=utf8', 'root', 'Mm721215');
    $dbh->setAttribute(PDO::ATTR_EMULATE_PREPARES, false); // neemuluj prepared statements pouzitelen od mysql 5.1.17  http://stackoverflow.com/questions/10113562/pdo-mysql-use-pdoattr-emulate-prepares-or-not    
    $statement = $dbh->prepare("select id as id, name as name, description as description, subject_id as subjectId from questions where subject_id = :subject_id", [PDO::ATTR_CURSOR => PDO::CURSOR_SCROLL]);
//    $statement->execute([':id' => 1]);
    $statement->bindValue(":subject_id", 11);
    $statement->execute();
    
    echo $statement->rowCount() ."\n";
    $offset = 10;
    
    while($row = $statement->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_ABS, $offset) ) {
        var_dump($row);
        $offset++;
//        $row->getBlah("serty", "asryy");
    }
    
    $statement->bindValue(":id", 2);
    $statement->execute();
    while($row = $statement->fetchObject(Question::class)) {
        var_dump($row);
    }
    
    $statement = null;
    $dbh = null;
} catch (PDOException $e) {
    print "Error!: " . $e->getMessage() . "<br/>";
}

/*
try {
    $dbh = new PDO('pgsql:host=localhost;dbname=mp_cz', 'mp', 'LLd1ra1d');

    $statement = $dbh->prepare("select * from  actions where id = :id;");
    $statement->execute([':id' => '00000000-0000-0000-0000-000000000003']);

    while($row = $statement->fetchObject('Test\TestDbObject')) {
        print_r($row);
    }
    $statement = null;
    $dbh = null;
} catch (PDOException $e) {
    print "Error!: " . $e->getMessage() . "<br/>";
}
*/