<?php

namespace IZON\DB;

use PDO;

use IZON\Logs\Logger;

use IZON\DB\DBObject;
use IZON\DB\Impl\DBConnectionCommon;

/**
 * vysledek dotazu, ktery dao vrati na dotaz
 */
class QueryResult {
    
    /**
     * query result is rerurned as object
     */
    const FETCH_OBJ = 1;

    /**
     * query result is rerurned as associative array, where keys are same as set in select part of sql query
     */
    const FETCH_ASSOC = 2;
    
    /**
     *
     * @var \PDOStatement 
     */
    protected $statement;

    /**
     *
     * @var DBConnectionCommon 
     */
    protected $dbConnection;

    /**
     * nazev tridy, ktera se ma vratit
     * @var type 
     */
    protected $className;


    /**
     * parametry dotazu
     * @var array 
     */
    protected $parametes;


    /**
     * maximalni pocet vysledku
     * @var int
     */
    protected $maxResults = PHP_INT_MAX;

    /**
     * prvni vysledek
     * @var int 
     */
    protected $firstResult = 0;
    
    /**
     * 
     * @var Logger 
     */
    private $log = NULL;
    
    function __construct(DBConnectionCommon $dbConnection, \PDOStatement $statement, $className, $parametes) {
        $this->statement = $statement;
        $this->dbConnection = $dbConnection;
        $this->className = $className;
        $this->parametes = $parametes;
        
        $this->log = Logger::getLogger(self::class);
    }

    
    /**
     * unikatni vysledek dotazu
     * @return DBObject
     */
    public function uniqueResult($fetchStyle = self::FETCH_OBJ) {
        $statement = $this->statement;
        $statement->bindValue(":maxResults", $this->maxResults);
        $statement->bindValue(":firstResult", $this->firstResult);
        
        $index = 0;
        foreach($this->parametes as $key => $value) {
            $statement->bindValue($key, $value);
        }
        $statement->execute();
        
        if( $statement->rowCount() > 1) {
            $statement->closeCursor();
            throw new \Exception("V unique result se vraci vice nez 1 zaznam");
        }
        
        if( $fetchStyle == self::FETCH_OBJ ) {
            $res = $this->dbConnection->fetchObject($this->className, $statement);
        } else if( $fetchStyle == self::FETCH_ASSOC ) {
            // TODO: predelat lepe a cisteji
            $res = $statement->fetch(\PDO::FETCH_ASSOC);
        } else {
            $statement->closeCursor();
            throw new Exception("Unsuported fetch type.");
        }
        
        $statement->closeCursor();
        
        if($res) {
            return $res;
        } else { // pokud se nenajde nevracej false ale null
            return NULL;
        }
    }

    /**
     * vsechny vysledky v seznamu
     * @return array
    */
    public function listResult($fetchStyle = self::FETCH_OBJ) {
        
        $statement = $this->statement;
        $statement->bindValue(":maxResults", $this->maxResults);
        
        $statement->bindValue(":firstResult", $this->firstResult);
        
        $index = 0;
        foreach($this->parametes as $key => $value) {
          //echo ":arg". $index.' = '. $value.'<br>';
            $statement->bindValue($key, $value);
//            echo $value ."\n";
        }
        
        $statement->execute();
        
        if( $fetchStyle == self::FETCH_OBJ ) {
             $res = $this->dbConnection->fetchObjectArray($this->className, $statement);
        } else if( $fetchStyle == self::FETCH_ASSOC ) {
            // TODO: predelat lepe a cisteji
            $res = $statement->fetchAll(\PDO::FETCH_ASSOC);
        } else {
            $statement->closeCursor();
            throw new Exception("Unsuported fetch type.");
        }
        
        $statement->closeCursor();
        return $res;
    }

    public function setMaxResults($maxResults) {
        $this->maxResults = $maxResults;
        return $this;
    }

    public function setFirstResult($firstResult) {
        $this->firstResult = $firstResult;
        return $this;
    }
}