<?php
$loader = require_once __DIR__ .'/../../../htdocs/vendor/autoload.php';
$loader->addPsr4('Test\\', __DIR__ .'/Test');
$loader->addPsr4('Test\\', __DIR__ .'/../DI/Test');
//$loader->addPsr4('Test\\', __DIR__ .'/Test');
$loader->add('IZON\\DB\\', __DIR__ .'/../../../htdocs/lib/DB/classes');

use DI\ContainerBuilder;

use Test\Domain\Question;
use Test\Dao\QuestionDao;
use \IZON\DB\Impl\DBConnectionMySQLImpl;

use ProxyManager\Factory\AccessInterceptorValueHolderFactory;

use ProxyManager\Factory\LazyLoadingValueHolderFactory;
use ProxyManager\Proxy\LazyLoadingInterface;


$dbConn = new DBConnectionMySQLImpl('localhost', 'organicka-chemie-losovani', 'root', 'Mm721215');

// proxy pro starani se o transakce
$factory = new AccessInterceptorValueHolderFactory();
$proxy = $factory->createProxy(
    new \Test\Services\Impl\TestServiceImpl(NULL),
    array('test' => function () { echo "Pre test!\n"; }),
    array('test' => function () { echo "Post test!\n"; })
);

$proxy->test();

echo get_parent_class($proxy) ."\n";

function createProxy() {
    $objectId = 1;

    // lazyloading proxy pro DB objekty
    $factory     = new LazyLoadingValueHolderFactory();
    $initializer = function (& $wrappedObject, LazyLoadingInterface $proxy, $method, array $parameters, & $initializer) use ($objectId) {
        $initializer   = null; // disable initialization
        $wrappedObject = new Question(); // fill your object with values here
        $wrappedObject->id = $objectId;

        return true; // confirm that initialization occurred correctly
    };

    $instance = $factory->createProxy('\Test\Domain\Question', $initializer);
    return $instance;
}

$instance = createProxy();

echo get_class($instance) ."\n";
echo get_parent_class($instance) ."\n";

echo $instance->getId() ."\n";

$instance->setId(11);

echo $instance->getId() ."\n";


// generovani Daa aby odpovidala interfacu
$interfaceName = "\Test\Dao\QuestionDao";
$reflector = new ReflectionClass($interfaceName); // class Foo of namespace A
$class = new Zend\Code\Generator\ClassGenerator($interfaceName ."Impl", $reflector->getNamespaceName(), null, "\IZON\DB\Impl\DaoImpl", [$interfaceName]);
// Configuring after instantiation
$method = new Zend\Code\Generator\MethodGenerator();
$method->setName('findBlah')
       ->setBody('echo "blah";');
$class->addMethodFromGenerator($method);
        
$gemenratd = $class->generate();
//echo $gemenratd;
eval($gemenratd);
//$class->add

$objectName = $interfaceName ."Impl";
$object = new $objectName($dbConn, 'Test\Dao\QuestionDao', 'questions');