<?php
/**
 * Created by PhpStorm.
 * User: honza
 * Date: 17.8.17
 * Time: 8:43
 */

namespace IZON\DB\Tests\DefaultNamingStrategy;

use IZON\DB\Impl\DefaultNamingStrategy;
use PHPUnit\Framework\TestCase;

class DefaultNamingStrategyTest extends TestCase {

    public function testPropertyToColumnName(){
        $ns = new DefaultNamingStrategy();

        //default using - words with nubers
        $columnName = $ns->propertyToColumnName('ahojTest');
        $this->assertEquals('ahoj_test', $columnName );

        $columnName = $ns->propertyToColumnName('AhojTest');
        $this->assertEquals('ahoj_test', $columnName );

        $columnName = $ns->propertyToColumnName('');
        $this->assertEquals('', $columnName );

        $columnName = $ns->propertyToColumnName('nova22Ahoj');
        $this->assertEquals('nova22ahoj', $columnName );

        $columnName = $ns->propertyToColumnName('nova22ahoj');
        $this->assertEquals('nova22ahoj', $columnName );

        $columnName = $ns->propertyToColumnName('1nova22ahoj');
        $this->assertEquals('1nova22ahoj', $columnName );

        $columnName = $ns->propertyToColumnName('1nova22ahoj23');
        $this->assertEquals('1nova22ahoj23', $columnName );

        //special unxepexted using
        $columnName = $ns->propertyToColumnName('1nova22ahoj--23');
        $this->assertEquals('1nova22ahoj--23', $columnName );

        $columnName = $ns->propertyToColumnName('nova2\2ahoj');
        $this->assertEquals('nova2\2ahoj', $columnName );

        $columnName = $ns->propertyToColumnName('nova2.2ahoj.');
        $this->assertEquals('nova2.2ahoj.', $columnName );

        $columnName = $ns->propertyToColumnName('AhojTest.!');
        $this->assertEquals('ahoj_test.!', $columnName );
    }


    public function testClassToTableName(){
        $ns = new DefaultNamingStrategy();

        $tableName = $ns->classToTableName('IZON\DB\Tests\DefaultNamingStrategy');
        $this->assertEquals('default_naming_strategys', $tableName );

        $tableName = $ns->classToTableName('IZON\DB\Tests\Strategy');
        $this->assertEquals('strategys', $tableName );

        $tableName = $ns->classToTableName('IZON\DB\Tests\strategy');
        $this->assertEquals('strategys', $tableName );

        try {
            $ns->classToTableName('IZON\DB\Tests\\');
            $this->fail('An expected exception has not been raised.');
        } catch (\Exception $expected) {

        }

        $tableName = $ns->classToTableName('IZON\DB\Tests\Strategy_Test');
        $this->assertEquals('strategy_tests', $tableName );

        $tableName = $ns->classToTableName('IZON\DB\Tests\Stra_tegyTest');
        $this->assertEquals('stra_tegy_tests', $tableName );

        $tableName = $ns->classToTableName('IZON\DB\Tests\Stra!tegyTest');
        $this->assertEquals('stra!tegy_tests', $tableName );
        $tableName = $ns->classToTableName('IZON\DB\Tests\Stra-tegyTest');
        $this->assertEquals('stra-tegy_tests', $tableName );
    }
}
