<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \PDO;

/**
 * Popis data
 */
class ManyToOneDefinition extends DateTimeDescription {
    
    function __construct(ClassDescription $classDesctiption, $propertyName, $columnName, $notNull) {
        parent::__construct($classDesctiption, $propertyName, $columnName, $notNull);
        
        $this->dbDataType = "bigint";
        $this->pdoDataType = PDO::PARAM_INT;
    }

    public function parse($value, $object) {
        if(  $value == NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        $date = Date::createFromFormat($this->format, $value);
        return $date;
    }

    public function serialize($value, $object) {
        if(  $value == NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        if( !($value instanceof Date) ) {
            throw new Exception("Hodnota musi byt null nebo IZON\Utils\Date");
        }
        
        $serializedString = $value->format($this->format);
        return $serializedString;
    }

    function getPdoDataType($value) {
        if( $value == NULL )
            return PDO::PARAM_NULL;
        return $this->pdoDataType;
    }
}
