<?php

namespace IZON\DB\Utils\PropertyDescriptions;

use \PDO;
use \Exception;

use IZON\DB\Utils\ClassDescription;

/**
 * Popis dat
 */
class BooleanDescription extends AbstractPropertyDescription {
    
    function __construct(ClassDescription $classDesctiption,
                            $propertyName, $columnName, $columnReturnName, $notNull) {
        parent::__construct($classDesctiption, $propertyName, $columnName, $columnReturnName, $notNull);
        
        $this->dbDataType = "boolean";
        $this->pdoDataType = PDO::PARAM_INT;
        $this->ansiDataType = AbstractPropertyDescription::ANSI_DATA_TYPE_BOOLEAN;
    }

    public function parse($value, $object) {
        if(  $value === NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        $date = boolval($value);
        return $date;
    }

    public function serialize($value, $object) {
        if(  $value === NULL ) {
            if( $this->getNotNull() ) {
                throw new Exception("". $this->getPropertyName() ." nesmi byt null");
            }
            return NULL;
        }
        
        return boolval($value);
    }

    function getPdoDataType($value) {
        if( $value === NULL )
            return PDO::PARAM_NULL;
        return $this->pdoDataType;
    }
}
