<?php

namespace IZON\DB\Impl;

/**
 * defaultni implementace NaminFactory
 */
class DefaultNamingStrategy implements \IZON\DB\NamingStrategy {
    
    /**
     * Prevede jmeno tridy na jmeno tabulky
     * @param string $className
     * @throws \Exception if name of class is empty
     * @return string
     */
    public function classToTableName($className) {
        $aux = explode ("\\", $className);
        $newClassName = $aux[count($aux)-1];
        if(empty($newClassName)){
            throw new \Exception('Class name can not be empty');
        }
        $cn = $this->addUnderscores($newClassName);
        return $cn ."s";
    }
    
    /**
     * prevede jmeno property na jmeno sloupce v tabulce
     * @param string $propertyName
     * @return string
     */
    public function propertyToColumnName($propertyName) {
        return $this->addUnderscores($propertyName);
    }
    
    /**
     * prevede jmeno z camel notace na podtrzitkovou notaci
     * 
     * @var string $name
     * @return string Description
     */
    protected static function addUnderscores($name) {
        //$name = str_replace('\\', '_', $name);        HONZA - I disable this - on error decomment
        $buf = preg_replace('/([a-z])([A-Z])/', '$1_$2', $name);
        return strtolower($buf);
    }
}
