<?php
namespace IZON\DB;

use IZON\DB\NamingStrategy;

/**
 * Rozhrani pripojeni k db
 * zapouzdruje PDO + pridava informace o db jaka se pouziva aby se mohly rozlisovat dotazy pro danou db
 */
interface DBConnection {

    /**
     * @return string tipe of db
     */
    public function getDbType();
    
    /**
     * @return NamingStrategy  naming strategy, ktera slouzi k prekladum tridy na tabulky
     */
    public function getNamingStrategy();
    
    /**
     * nastavuje gamimg stratey podle ktere se maji prekladat property na jmena tabulek a sloupcu
     * @param NamingStrategy $namingStrategy
     */
    public function setNamingStrategy(NamingStrategy $namingStrategy);
    
    /**
     *  returns object of class $className with id $id
     * @param type $className
     * @param mixed $id
     * @return object returned object
     */
    public function load($className, $id);

    /**
     * 
     * @param class $className
     * @return QueryResult returns all object of class $className in undetermined order
     */
    public function loadAll($className);

    /**
     * njde vsechny objekty odpovidajici parametrum
     * @param class $className
     * @param array $params parametry podle kterych e ma hledat
     * @param array $orders jak se maji vysledky seradt
     * @return QueryResult returns all object of class $className in undetermined order
     */
    public function find($className, array $params, array $orders = []);
    
    /**
     * 
     * @param objects $obj updates this object
     */
    public function update($obj);

    /**
     * saves this object
     * @param type $obj
     * @return mixed id of newly added object
     */
    public function save($obj);

    /**
     * deletes object form db
     * @param mixed|object $obj id of object to delete or object to delete
     */
    public function delete($obj);
    
    /**
     * closes connection an frees all cashed data
     */
    public function close();
    
    /**
     * zapocne transakci
     */
    public function beginTransaction();
    
    /**
     * commituje transakci
     */
    public function commit();
    
    /**
     * rollbackuje transakci
     */
    public function rollBack();
}
