<?php

namespace IZON\DBLocale\Interceptor;

use Doctrine\ORM\EntityManagerInterface;
use IZON\DBLocale\Domain\DBLocale;
use IZON\DBLocale\Repositories\LocaleRepository;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * Nastavuje informace o lokalizaci - zemi, jazyk, měnu...
 *
 * @deprecated do not use, use $request->getLocale() in controller/interceptor or getLocale() in view
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class DBLocaleInterceptor implements Interceptor
{
    /**
     * Pod jaky nazvem je informace o locale dostupny
     * @deprecated do not use, use $request->getLocale() in controller/interceptor or getLocale() in view
     */
    public const AVAILABLE_AS = '_locale';
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    /**
     * @var LocaleRepository
     */
    protected $localeRepository;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
        $this->localeRepository = $entityManager->getRepository(DBLocale::class);
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $mav)
    {
        $mav->putParameter(self::AVAILABLE_AS, $request->getParameter(self::AVAILABLE_AS));
    }

    public function preHandle(HttpRequest $request)
    {
        $locale = $request->getLocale();
        $localeTag = $locale->toLocaleTag();

        /** @var DBLocale $locale */
        $locale = $this->localeRepository->findOneBy(['localeTag' => $localeTag]);

        //        $request->setSessionParameter(self::AVAILABLE_AS, $locale);
        $request->addParameter(self::AVAILABLE_AS, $locale);
    }
}
