<?php

namespace IZON\DBLocale\Interceptor;

use IZON\DBLocale\Classes\GlobalCurrency;
use IZON\DBLocale\Services\DBCurrencyService;
use IZON\MVC\Interceptors\InterceptorInterface;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;

class DBCurrencyInterceptor implements InterceptorInterface
{
    /**
     * Parameter identifier - in mav and in request.
     */
    public const AVAILABLE_AS = '_currency';

    protected GlobalCurrency $globalCurrency;

    protected DBCurrencyService $currencyService;

    /**
     * DBCurrencyInterceptor constructor.
     * @param DBCurrencyService $DBCurrencyService
     */
    public function __construct(DBCurrencyService $DBCurrencyService, GlobalCurrency $globalCurrency)
    {
        $this->currencyService = $DBCurrencyService;
        $this->globalCurrency = $globalCurrency;
    }

    public function afterCompletion(
        HttpRequestInterface $request,
        HttpResponseInterface $response,
        $exception
    ): HttpResponseInterface {
        return $response;
    }

    public function postHandle(HttpRequestInterface $request, HttpResponseInterface $response): HttpResponseInterface
    {
        return $response;
    }

    public function preHandle(HttpRequestInterface $request): HttpRequestInterface
    {
        $currency = $this->currencyService->getCurrentCurrency();

        if ($currency) {
            $this->globalCurrency->setCurrency($currency);
        }

        return $request;
    }
}
