<?php

namespace IZON\DBLocale\Domain;

use Doctrine\ORM\Mapping as ORM;
use IZON\DBLocale\Repositories\LocaleRepository;
use IZON\Utils\Locale;

/**
 * represents locale
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity(repositoryClass: LocaleRepository::class)]
#[ORM\Table(name: "core_dblocale_locales")]
class DBLocale
{
    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    /**
     * @var string tags from RFC http://php.net/manual/en/class.locale.php
     */
    #[ORM\Column]
    protected string $localeTag;

    #[ORM\ManyToOne]
    protected DBCountry $country;

    #[ORM\ManyToOne]
    protected DBLanguage $language;

    #[ORM\ManyToOne]
    protected DBCurrency $currency;

    protected ?Locale $locale = null;

    /**
     * @deprecated is not mapped to db
     */
    protected bool $active = false;

    /// generovane gettery a settery
    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @deprecated is not mapped to db
     */
    public function getActive(): bool
    {
        return $this->active;
    }

    public function getCountry(): DBCountry
    {
        return $this->country;
    }

    public function setCountry(DBCountry $country)
    {
        $this->country = $country;
    }

    public function getLanguage(): DBLanguage
    {
        return $this->language;
    }

    public function setLanguage(DBLanguage $language)
    {
        $this->language = $language;
    }

    public function getCurrency(): DBCurrency
    {
        return $this->currency;
    }

    public function setCurrency(DBCurrency $currency)
    {
        $this->currency = $currency;
    }

    public function getLocale(): Locale
    {
        if (!is_null($this->locale)) {
            return $this->locale;
        }

        $this->locale = Locale::forLocaleTag($this->getLocaleTag());
        return $this->locale;
    }

    /**
     * @deprecated not needed, getLocale() creates locale from localeTag
     */
    public function setLocale(Locale $locale): void
    {
        $this->locale = $locale;
    }

    public function getLocaleTag(): string
    {
        return $this->localeTag;
    }

    public function setLocaleTag(string $localeTag): void
    {
        $this->localeTag = $localeTag;
    }

    /**
     * @deprecated is not mapped to db
     */
    public function setActive(bool $active): void
    {
        $this->active = $active;
    }
}
