<?php

namespace IZON\DBLocale\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * represents language part of locale
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_dblocale_languages")]
class DBLanguage
{
    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id;

    #[ORM\Column]
    protected string $code;

    #[ORM\Column]
    protected string $name;

    /**
     * @var string locale part determining language
     */
    #[ORM\Column]
    protected string $localeTag;


    /// generovane gettery a settery
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getCode()
    {
        return $this->code;
    }

    public function setCode($code)
    {
        $this->code = $code;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getLocaleTag()
    {
        return $this->localeTag;
    }

    public function setLocaleTag($localeTag)
    {
        $this->localeTag = $localeTag;
    }

    public function getLocaleCode()
    {
        return $this->code;
    }
}
