<?php

namespace IZON\DBLocale\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * represents currency. contains name, rouding, ..
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_dblocale_currencies")]
class DBCurrency
{
    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id;

    #[ORM\Column]
    protected string $code;

    #[ORM\Column]
    protected string $htmlString;

    #[ORM\Column]
    protected int $rounding;

    /**
     * @var string locale part determining currency
     */
    #[ORM\Column]
    protected string $localeTag;


    /// generovane getttery a settery
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getCode()
    {
        return $this->code;
    }

    public function setCode($code)
    {
        $this->code = $code;
    }

    public function getHtmlString()
    {
        return $this->htmlString;
    }

    public function setHtmlString($htmlString)
    {
        $this->htmlString = $htmlString;
    }

    public function getRounding()
    {
        return $this->rounding;
    }

    public function setRounding($rounding)
    {
        $this->rounding = $rounding;
    }

    public function getLocaleCode()
    {
        return $this->getLocaleTag();
    }

    public function getLocaleTag()
    {
        return $this->localeTag;
    }

    public function setLocaleTag($localeTag)
    {
        $this->localeTag = $localeTag;
    }

    public function setLocaleCode($localeTag)
    {
        $this->setLocaleTag($localeTag);
    }
}
