<?php

namespace IZON\DBLocale\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * represents country part of locale
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_dblocale_countries")]
class DBCountry
{
    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    #[ORM\Column]
    protected string $code;

    #[ORM\Column]
    protected string $name;

    #[ORM\ManyToOne(targetEntity: DBCurrency::class)]
    protected DBCurrency $currency;

    #[ORM\Column]
    protected string $shortCut;

    /**
     * @var string locale part determining country
     */
    #[ORM\Column]
    protected string $localeTag;


    /// generovane gettery a settery
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getCode()
    {
        return $this->code;
    }

    public function setCode($code)
    {
        $this->code = $code;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getCurrency(): DBCurrency
    {
        return $this->currency;
    }

    public function setCurrency(DBCurrency $currency)
    {
        $this->currency = $currency;
    }

    public function getShortCut()
    {
        return $this->shortCut;
    }

    public function setShortCut($shortCut)
    {
        $this->shortCut = $shortCut;
    }

    public function getLocaleTag()
    {
        return $this->localeTag;
    }

    public function setLocaleTag($localeTag)
    {
        $this->localeTag = $localeTag;
    }

    public function getLocaleCode()
    {
        return $this->localeTag;
    }
}
