<?php
namespace IZON\DBLocale\Domain;


use Doctrine\ORM\Mapping as ORM;
use IZON\DBLocale\Repositories\LocaleRepository;
use IZON\Utils\Locale;

/**
 * represents locale
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity(repositoryClass: LocaleRepository::class)]
#[ORM\Table(name: "core_dblocale_locales")]
class DBLocale {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    /**
     * @var string tags from RFC http://php.net/manual/en/class.locale.php
     */
    #[ORM\Column]
    protected string $localeTag;

    #[ORM\ManyToOne]
    protected DBCountry $country;

    #[ORM\ManyToOne]
    protected DBLanguage $language;

    #[ORM\ManyToOne]
    protected DBCurrency $currency;

    /**
     * @var Locale
     */
    protected $locale;


    /// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function getActive() {
        return $this->active;
    }

    function getCountry(): DBCountry {
        return $this->country;
    }

    function getLanguage(): DBLanguage {
        return $this->language;
    }

    function getCurrency(): DBCurrency {
        return $this->currency;
    }

    function getLocale(): Locale {
        if(!is_null($this->locale)) {
            return $this->locale;
        }

        $this->setLocale(Locale::forLocaleTag($this->getLocaleTag()));
        return $this->getLocale();
    }

    function setId($id) {
        $this->id = $id;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }

    function setActive($active) {
        $this->active = $active;
    }

    function setCountry(DBCountry $country) {
        $this->country = $country;
    }

    function setLanguage(DBLanguage $language) {
        $this->language = $language;
    }

    function setCurrency(DBCurrency $currency) {
        $this->currency = $currency;
    }

    function setLocale(Locale $locale) {
        $this->locale = $locale;
    }
}
