<?php
namespace IZON\DBLocale\Domain;


use Doctrine\ORM\Mapping as ORM;

/**
 * represents language part of locale
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_dblocale_languages")]
class DBLanguage {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id;

    #[ORM\Column]
    protected string $code;

    #[ORM\Column]
    protected string $name;

    /**
     * @var string locale part determining language
     */
    #[ORM\Column]
    protected string $localeTag;


    /// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getCode() {
        return $this->code;
    }

    function getName() {
        return $this->name;
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }

    public function getLocaleCode() {
        return $this->code;
    }
}
