<?php

namespace IZON\DBLocale\Domain;


use Doctrine\ORM\Mapping as ORM;

/**
 * represents currency. contains name, rouding, ..
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_dblocale_currencies")]
class DBCurrency {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id;

    #[ORM\Column]
    protected string $code;

    #[ORM\Column]
    protected string $htmlString;

    #[ORM\Column]
    protected int $rounding;

    /**
     * @var string locale part determining currency
     */
    #[ORM\Column]
    protected string $localeTag;


/// generovane getttery a settery
    function getId() {
        return $this->id;
    }

    function getCode() {
        return $this->code;
    }

    function getHtmlString() {
        return $this->htmlString;
    }

    function getRounding() {
        return $this->rounding;
    }

    function getLocaleCode() {
        return $this->getLocaleTag();
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setHtmlString($htmlString) {
        $this->htmlString = $htmlString;
    }

    function setRounding($rounding) {
        $this->rounding = $rounding;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }
    
    function setLocaleCode($localeTag) {
        $this->setLocaleTag($localeTag);
    }
}
