<?php

namespace IZON\DBLocale\Services;

use Doctrine\ORM\EntityManagerInterface;
use IZON\DB\Repository\BaseRepository;
use IZON\DBLocale\Domain\DBCurrency;
use IZON\MVC\Config;
use IZON\MVC\URLDomain\URLDomain;

class DBCurrencyService {

    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    /**
     * @var BaseRepository
     */
    protected $currencyRepository;
    /**
     * @var URLDomain
     */
    protected $urlDomain;

    /**
     * DBCurrencyService constructor.
     * @param EntityManagerInterface $entityManager
     * @param URLDomain $urlDomain
     */
    public function __construct(EntityManagerInterface $entityManager, URLDomain $urlDomain) {
        $this->entityManager = $entityManager;
        $this->urlDomain = $urlDomain;

        $this->currencyRepository = $entityManager->getRepository(DBCurrency::class);
    }

    /**
     * Gets current DBCurrency object by current urlDomain and 'domain.currencies' config.
     *
     * @return DBCurrency|null
     * @throws \Exception If no currency is defined for current domain.
     */
    public function getCurrentCurrency(): ?DBCurrency {
        $config = Config::getValue('domain.currencies');
        if(!array_key_exists($this->urlDomain->getDomainUID(), $config)) {
            throw new \Exception("Currency is not set for domain {$this->urlDomain->getDomainUID()}");
        }
        $currencyId = $config[$this->urlDomain->getDomainUID()];
        /** @var DBCurrency $currency */
        $currency = $this->currencyRepository->find(reset($currencyId));
        return $currency;
    }



}
