<?php

namespace IZON\DBLocale\Interceptor;

use Doctrine\ORM\EntityManagerInterface;
use IZON\DB\Repository\BaseRepository;
use IZON\DBLocale\Domain\DBCurrency;
use IZON\DBLocale\Classes\GlobalCurrency;
use IZON\DBLocale\Services\DBCurrencyService;
use IZON\MVC\Config;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use IZON\MVC\URLDomain\URLDomain;

class DBCurrencyInterceptor implements Interceptor {

    /**
     * Parameter identifier - in mav and in request.
     */
    const AVAILABLE_AS = '_currency';
    /**
     * @var GlobalCurrency
     */
    protected $globalCurrency;

    /**
     * @var DBCurrencyService
     */
    protected $currencyService;

    /**
     * DBCurrencyInterceptor constructor.
     * @param DBCurrencyService $DBCurrencyService
     */
    public function __construct(DBCurrencyService $DBCurrencyService, GlobalCurrency $globalCurrency) {
        $this->currencyService = $DBCurrencyService;
        $this->globalCurrency = $globalCurrency;
    }

    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function postHandle(HttpRequest $request, ModelAndView $mav) {

    }

    public function preHandle(HttpRequest $request) {
        $currency = $this->currencyService->getCurrentCurrency();
        if($currency) {
            $this->globalCurrency->setCurrency($currency);
        }
    }

}
