<?php
namespace IZON\DBLocale\Domain;


use Doctrine\ORM\Mapping as ORM;
use IZON\Utils\Locale;

/**
 * represents locale
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 * @ORM\Entity(repositoryClass="IZON\DBLocale\Repositories\LocaleRepository")
 * @ORM\Table(name="core_dblocale_locales")
 */
class DBLocale {

    /**
     * @ORM\Id()
     * @ORM\Column()
     * @ORM\GeneratedValue()
     * @var int
     */
    protected $id;

    /**
     * @ORM\Column()
     * @var string tags from RFC http://php.net/manual/en/class.locale.php
     */
    protected $localeTag;

    /**
     * @Column
     * @var bool
     */
//    protected $active;

    /**
     * @ORM\ManyToOne(targetEntity="DBCountry")
     * @ORM\JoinColumn()
     * @var DBCountry
     */
    protected $country;

    /**
     * @ORM\ManyToOne(targetEntity="DBLanguage")
     * @ORM\JoinColumn()
     * @var DBLanguage
     */
    protected $language;

    /**
     * @ORM\ManyToOne(targetEntity="DBCurrency")
     * @ORM\JoinColumn()
     * @var DBCurrency
     */
    protected $currency;

    /**
     * @var Locale
     */
    protected $locale;


    /// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function getActive() {
        return $this->active;
    }

    function getCountry(): DBCountry {
        return $this->country;
    }

    function getLanguage(): DBLanguage {
        return $this->language;
    }

    function getCurrency(): DBCurrency {
        return $this->currency;
    }

    function getLocale(): Locale {
        if(!is_null($this->locale)) {
            return $this->locale;
        }

        $this->setLocale(Locale::forLocaleTag($this->getLocaleTag()));
        return $this->getLocale();
    }

    function setId($id) {
        $this->id = $id;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }

    function setActive($active) {
        $this->active = $active;
    }

    function setCountry(DBCountry $country) {
        $this->country = $country;
    }

    function setLanguage(DBLanguage $language) {
        $this->language = $language;
    }

    function setCurrency(DBCurrency $currency) {
        $this->currency = $currency;
    }

    function setLocale(Locale $locale) {
        $this->locale = $locale;
    }
}
