<?php

namespace IZON\DBLocale\Interceptor;

use Doctrine\ORM\EntityManagerInterface;
use IZON\DB\Repository\BaseRepository;
use IZON\DBLocale\Domain\DBCurrency;
use IZON\DBLocale\Classes\GlobalCurrency;
use IZON\MVC\Config;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use IZON\MVC\URLDomain\URLDomain;

class DBCurrencyInterceptor implements Interceptor {

    /**
     * Parameter identifier - in mav and in request.
     */
    const AVAILABLE_AS = '_currency';
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    /**
     * @var BaseRepository
     */
    protected $currencyRepository;
    /**
     * @var URLDomain
     */
    protected $urlDomain;
    /**
     * @var GlobalCurrency
     */
    protected $globalCurrency;
    /**
     * DBCurrencyInterceptor constructor.
     * @param EntityManagerInterface $entityManager
     * @param URLDomain $URLDomain
     */
    public function __construct(EntityManagerInterface $entityManager, GlobalCurrency $globalCurrency, URLDomain $URLDomain) {
        $this->entityManager = $entityManager;
        $this->urlDomain = $URLDomain;
        $this->globalCurrency = $globalCurrency;
        $this->currencyRepository = $entityManager->getRepository(DBCurrency::class);
    }

    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function postHandle(HttpRequest $request, ModelAndView $mav) {

    }

    public function preHandle(HttpRequest $request) {
        $config = Config::getValue('domain.currencies');
        if(!array_key_exists($this->urlDomain->getDomainUID(), $config)) {
            throw new \Exception("Currency is not set for domain {$this->urlDomain}");
        }
        $currencyId = $config[$this->urlDomain->getDomainUID()];
        /** @var DBCurrency $currency */
        $currency = $this->currencyRepository->find(reset($currencyId));
        $this->globalCurrency->setCurrency($currency);
    }

}
