<?php
namespace IZON\DBLocale\Domain;


use Doctrine\ORM\Mapping as ORM;

/**
 * represents country part of locale
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 * @ORM\Entity()
 * @ORM\Table(name="core_dblocale_countries")
 */
class DBCountry {

    /**
     * @ORM\Id()
     * @ORM\Column()
     * @ORM\GeneratedValue()
     * @var int
     */
    protected $id;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $code;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $name;

    /**
     * @ORM\ManyToOne(targetEntity="DBCurrency")
     * @ORM\JoinColumn()
     * @var DBCurrency
     */
    protected $currency;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $shortCut;

    /**
     * @ORM\Column()
     * @var string locale part determining country
     */
    protected $localeTag;


/// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getCode() {
        return $this->code;
    }

    function getName() {
        return $this->name;
    }

    function getCurrency(): DBCurrency {
        return $this->currency;
    }

    function getShortCut() {
        return $this->shortCut;
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setCurrency(DBCurrency $currency) {
        $this->currency = $currency;
    }

    function setShortCut($shortCut) {
        $this->shortCut = $shortCut;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }

    public function getLocaleCode() {
        return $this->localeTag;
    }
}
